# 機能設計書 98-C# REPL (csi)

## 概要

本ドキュメントは、C# Interactive (csi) コマンドラインツールの機能設計を定義する。csi は、C# コードを対話的に実行するための REPL (Read-Eval-Print Loop) 環境を提供するコマンドラインアプリケーションである。

### 本機能の処理概要

csi.exe は、コマンドラインから C# コードを対話的に入力・実行できる環境を提供する。単一のスクリプトファイル (.csx) の実行も可能であり、開発者はコンパイル・ビルドのサイクルなしに C# コードを素早く試行できる。

**業務上の目的・背景**：コードのプロトタイピング、API の試用、簡単なスクリプト実行など、フルプロジェクトを作成するほどではない場面で、C# コードを即座に実行できる環境を提供する。

**機能の利用シーン**：
- コマンドラインでの対話的 C# コード実行
- .csx スクリプトファイルの実行
- API の動作確認やプロトタイピング
- 教育目的での C# 学習

**主要な処理内容**：
1. コマンドライン引数のパース
2. レスポンスファイル（csi.rsp）の読み込み
3. スクリプトファイルの実行またはインタラクティブモードの開始
4. REPL ループによる対話的実行
5. 結果の表示とフォーマット

**関連システム・外部連携**：.NET SDK、C# スクリプトエンジン（CSharpScript）、NuGet パッケージ参照。

**権限による制御**：実行環境のファイルシステム権限に従う。

## 関連画面

本機能はコンソールアプリケーションであり、コマンドライン UI を使用する。

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コンソール | 主画面 | 対話的コード入力と結果表示 |

## 機能種別

コマンドラインツール / REPL / スクリプト実行

## 入力仕様

### コマンドライン引数

| 引数 | 説明 | 例 |
|-----|------|-----|
| <script.csx> | 実行するスクリプトファイル | `csi script.csx` |
| -r:<reference> | アセンブリ参照の追加 | `csi -r:Newtonsoft.Json.dll` |
| -u:<namespace> | using ディレクティブの追加 | `csi -u:System.IO` |
| -i | インタラクティブモードで開始 | `csi -i` |
| -- <args> | スクリプトに渡す引数 | `csi script.csx -- arg1 arg2` |
| -help | ヘルプの表示 | `csi -help` |
| -version | バージョンの表示 | `csi -version` |

### 入力データソース

- コマンドライン引数
- 標準入力（インタラクティブモード）
- スクリプトファイル
- レスポンスファイル（csi.rsp）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 実行結果 | 文字列 | フォーマットされた実行結果 |
| エラーメッセージ | 文字列 | コンパイルエラーや実行時エラー |
| 終了コード | int | 0: 成功、1: エラー |

### 出力先

- 標準出力（結果）
- 標準エラー出力（エラー）

## 処理フロー

### 処理シーケンス

```
1. エントリーポイント
   └─ Csi.Main(args)
2. 初期設定
   └─ BuildPaths 構築、レスポンスファイル読み込み
3. コンパイラ初期化
   └─ CSharpInteractiveCompiler 作成
4. ランナー初期化
   └─ CommandLineRunner 作成
5. 実行モード判定
   └─ スクリプトファイル指定 or インタラクティブモード
6. 実行
   └─ RunInteractive または RunScript
7. 終了コード返却
```

### フローチャート

```mermaid
flowchart TD
    A[csi.exe 起動] --> B[BuildPaths 構築]
    B --> C[csi.rsp 読み込み]
    C --> D[CSharpInteractiveCompiler 作成]
    D --> E[CommandLineRunner 作成]
    E --> F{バージョン/ヘルプ表示?}
    F -->|Yes| G[表示して終了]
    F -->|No| H{スクリプトファイル指定?}
    H -->|Yes| I[RunScript]
    H -->|No| J[RunInteractiveLoop]
    I --> K{エラー?}
    K -->|Yes| L[終了コード 1]
    K -->|No| M[終了コード = 戻り値]
    J --> N[REPL ループ]
    N --> O[入力待ち > ]
    O --> P{入力あり?}
    P -->|No| Q[終了]
    P -->|Yes| R{#help?}
    R -->|Yes| S[ヘルプ表示]
    R -->|No| T[コンパイル・実行]
    T --> U[結果表示]
    S --> O
    U --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-98-01 | レスポンスファイル | csi.rsp からデフォルト参照とインポートを読み込み | 常に |
| BR-98-02 | スクリプト引数 | -- 以降の引数をスクリプトの Args として渡す | スクリプト実行時 |
| BR-98-03 | 入力継続判定 | 不完全な構文の場合は継続入力（. プロンプト）を許可 | インタラクティブモード |
| BR-98-04 | 最大エラー表示数 | エラーは最大 5 件まで表示 | コンパイルエラー時 |

### 計算ロジック

終了コードはスクリプトの戻り値（int の場合）または例外の HResult を返す。

## データベース操作仕様

本機能はデータベースを直接操作しない。

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | コンパイルエラー | 構文エラーまたは型エラー | コードを修正 |
| 1 | スクリプトファイル不正 | 複数ファイル指定または非スクリプト | 1つの .csx を指定 |
| - | 実行時例外 | スクリプト実行中のエラー | 赤色で例外表示 |

### リトライ仕様

インタラクティブモードではエラー後も入力を継続可能。

## トランザクション仕様

トランザクション不要。

## パフォーマンス要件

- 起動時間: 1秒以内（ウォームアップ後）
- REPL 応答: 入力完了後 500ms 以内

## セキュリティ考慮事項

- 実行環境のユーザー権限で動作
- 信頼できないスクリプトの実行に注意

## 備考

csi.exe は .NET SDK に含まれる。`dotnet csi` コマンドとしても利用可能。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Csi.cs | `src/Interactive/csi/Csi.cs` | Main エントリーポイント |

**主要処理フロー**:
- **16行目**: InteractiveResponseFileName = "csi.rsp"
- **18-51行目**: Main メソッド
- **24行目**: csi ディレクトリの取得
- **26-30行目**: BuildPaths 構築
- **32-36行目**: CSharpInteractiveCompiler 作成
- **38-42行目**: CommandLineRunner 作成
- **44行目**: runner.RunInteractive() 呼び出し

#### Step 2: インタラクティブコンパイラを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CSharpInteractiveCompiler.cs | `src/Scripting/CSharp/Hosting/CSharpInteractiveCompiler.cs` | C# 対話型コンパイラ |

#### Step 3: コマンドラインランナーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CommandLineRunner.cs | `src/Scripting/Core/Hosting/CommandLine/CommandLineRunner.cs` | REPL ループ実装 |

**主要処理フロー**:
- **53-69行目**: RunInteractive - エントリーポイント
- **74-148行目**: RunInteractiveCore - コア処理
- **200-220行目**: RunScript - スクリプト実行
- **222-292行目**: RunInteractiveLoop - REPL ループ

**読解のコツ**:
- `>` プロンプトで入力待ち
- `. ` プロンプトで継続入力待ち
- `#help` コマンドでヘルプ表示
- Ctrl+Z（EOF）で終了

### プログラム呼び出し階層図

```
Csi.Main(args)
    │
    └─ new CommandLineRunner(console, compiler, scriptCompiler, objectFormatter)
           │
           └─ RunInteractive()
                  └─ RunInteractiveCore(errorLogger)
                         │
                         ├─ スクリプト指定時
                         │      └─ RunScript(options, code, errorLogger)
                         │             └─ script.RunAsync(globals)
                         │
                         └─ インタラクティブ時
                                └─ RunInteractiveLoop(options, initialCode)
                                       │
                                       ├─ Console.In.ReadLine()
                                       ├─ IsCompleteSubmission(tree)
                                       ├─ BuildAndRun(script, globals, state, options)
                                       │      ├─ script.Compile()
                                       │      └─ script.RunAsync() / script.RunFromAsync()
                                       └─ globals.Print(result)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

コマンドライン引数 ───────▶ CSharpInteractiveCompiler ────▶ ParseOptions
      │                            │
      ▼                            ▼
csi.rsp ───────────────────▶ ScriptOptions ─────────────────▶ 参照/インポート
      │                            │
      ▼                            ▼
stdin ──────────────────────▶ ReadLine() ──────────────────▶ SourceText
      │                            │
      ▼                            ▼
                         Script.Create/Compile/Run ─────────▶ ScriptState
                                   │
                                   ▼
                         ObjectFormatter.FormatObject() ────▶ stdout
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Csi.cs | `src/Interactive/csi/` | ソース | エントリーポイント |
| csi.rsp | `src/Interactive/csi/` | 設定 | デフォルト参照とインポート |
| CSharpInteractiveCompiler.cs | `src/Scripting/CSharp/Hosting/` | ソース | C# 対話型コンパイラ |
| CommandLineRunner.cs | `src/Scripting/Core/Hosting/CommandLine/` | ソース | REPL ランナー |
| CSharpObjectFormatter.cs | `src/Scripting/CSharp/Hosting/ObjectFormatting/` | ソース | 結果フォーマッター |
| ConsoleIO.cs | `src/Scripting/Core/Hosting/CommandLine/` | ソース | コンソール入出力 |
| InteractiveScriptGlobals.cs | `src/Scripting/Core/Hosting/` | ソース | グローバルオブジェクト |
| BuildPaths.cs | `src/Compilers/Core/CommandLine/` | ソース | パス設定 |
